/*
 * FILE								: usart.c
 * DESCRIPTION				: This file is iHMI43 usart driver demo.
 * Author							: XiaomaGee@Gmail.com
 * Copyright					:
 *
 * History
 * --------------------
 * Rev								: 0.00
 * Date								: 08/26/2012
 *
 * create.
 * --------------------
 */

//-----------------Include files-------------------------//
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
 
#include <ctype.h>
#include <math.h>
#include <stdarg.h>

#include "..\FWlib\inc\stm32f4xx_rcc.h"
#include "..\FWlib\inc\stm32f4xx_gpio.h"
#include "..\FWlib\inc\stm32f4xx_usart.h"
#include "..\include\usart.h"


//-----------------Variable------------------------------//  

//usart4 debug
static int send_string_to_usart4(char * str);
static int send_byte_to_usart4(char data);
static int initialize_usart4(unsigned long int baudrate);
static int my_printf4(const char * fmt,...);
static int send_buffer4(void * ,int);


UART_T usart4 = {
	.receive_ok_flag=0,
	.counter=0,
	.send_byte = send_byte_to_usart4,
	.send_string = send_string_to_usart4,
	.initialize=initialize_usart4,
	.printf=my_printf4,
	.send_buffer = send_buffer4
	};
//-----------------Function------------------------------//

//USART4 DEBUG
/*
 * Name       				: initialize_usart4
 * Description				: ---
 * Author							: XiaomaGee
 * 
 * History
 * -------------------
 * Rev								: 0.00
 * Date       				: 08/26/2012
 *
 * create.
 * -------------------
 */
static int initialize_usart4(unsigned long int baudrate)
{	
	GPIO_InitTypeDef GPIO_InitStructure;
	USART_InitTypeDef USART_InitStructure;
	NVIC_InitTypeDef NVIC_InitStructure;
	
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOA,ENABLE);
	
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0;//PA0Ϊ
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOA, &GPIO_InitStructure);    

  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1;//PA1Ϊ
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
	
	GPIO_PinAFConfig(GPIOA,GPIO_PinSource0,GPIO_AF_UART4);
	GPIO_PinAFConfig(GPIOA,GPIO_PinSource1,GPIO_AF_UART4);
	
	USART_DeInit(UART4);
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_UART4, ENABLE);//ʹUART4ʱ
	  
	USART_InitStructure.USART_BaudRate = baudrate;	//
	USART_InitStructure.USART_WordLength = USART_WordLength_8b;	//8λ
	USART_InitStructure.USART_StopBits = USART_StopBits_1;	//1ֹͣλ
	USART_InitStructure.USART_Parity = USART_Parity_No ;		//
	USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;	//
	USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;	//
	USART_Init(UART4, &USART_InitStructure); //ʼUART4
  USART_Cmd(UART4, ENABLE);//ʹUART4
	USART_ITConfig(UART4,USART_IT_PE,ENABLE);	//
	USART_ITConfig(UART4,USART_IT_RXNE,ENABLE);//UART4ж
	
	NVIC_InitStructure.NVIC_IRQChannel = UART4_IRQn; //򿪴һж
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
	
	return 0;
}

/*
 * Name       				: send_buffer4
 * Description				: ---
 * Author							: XiaomaGee
 * 
 * History
 * -------------------
 * Rev								: 0.00
 * Date       				: 08/26/2012
 *
 * create.
 * -------------------
 */
static int
send_buffer4(void * buf,int len)  //
{
	char *p = (char *)buf;
	
	if(len <= 0)return -1;
	
	while(len --){
		send_byte_to_usart4(*p);
		p ++;
	}
	
	return 0;
}

/*
 * Name       				: send_byte_to_usart4
 * Description				: ---
 * Author							: XiaomaGee
 * 
 * History
 * -------------------
 * Rev								: 0.00
 * Date       				: 08/26/2012
 *
 * create.
 * -------------------
 */
static int 
send_byte_to_usart4(char data)    //TTLͨ
{
	
	while(!(USART_GetFlagStatus(UART4,USART_FLAG_TC) == 1)); //ȴ
	USART_SendData(UART4,data);	            //дݼĴ
	
	return 0;
}
/*
 * Name       				: send_string_to_usart4
 * Description				: ---
 * Author							: XiaomaGee
 * 
 * History
 * -------------------
 * Rev								: 0.00
 * Date       				: 08/26/2012
 *
 * create.
 * -------------------
 */
static int 
send_string_to_usart4(char * str)   //TTLͨ
{
	while(*str!='\0'){
	while(!(USART_GetFlagStatus(UART4,USART_FLAG_TC) == 1));
		USART_SendData(UART4,*str++);	//	
	}
	return 0;
}
/*
 * Name       				: UART4_IRQHandler
 * Description				: ---
 * Author							: XiaomaGee
 * 
 * History
 * -------------------
 * Rev								: 0.00
 * Date       				: 08/26/2012
 *
 * create.
 * -------------------
 */

int 
UART4_IRQHandler(void)
{	
  while(USART_GetFlagStatus(UART4,USART_FLAG_RXNE) == 0);                                                                 
 	usart4.receive_buffer[usart4.counter++]=USART_ReceiveData(UART4); //
	
	usart4.send_byte(usart4.receive_buffer[usart4.counter - 1]);
 	
 	if(usart4.receive_buffer[usart4.counter-1]=='\r' ){   			
			usart4.receive_buffer[usart4.counter-1]=0;
 			usart4.counter=0;                                
 	   	usart4.receive_ok_flag=1;                      
 		}
	return 0;			
}
/*
 * Name       				: printf
 * Description				: ---
 * Author							: XiaomaGee
 * 
 * History
 * -------------------
 * Rev								: 0.00
 * Date       				: 08/26/2012
 *
 * create.
 * -------------------
 */
static int
my_printf4(const char * fmt,...)//1
{
	__va_list arg_ptr; 
	char buf[UART_BUFFER_SIZE];
  		
	memset(buf,'\0',sizeof(buf));

	va_start(arg_ptr,fmt);
	vsprintf(buf,fmt,arg_ptr);
	va_end(arg_ptr);

	send_string_to_usart4(buf);

	return 0;
}
