/*
 * --------------------
 * Company							: LUOYANG GINGKO TECHNOLOGY CO.,LTD.
 : ӿƼ޹˾
 * --------------------
 * Project Name					: iCore3
 * Description					: iCore3_demo
 * --------------------
 * Tool Versions				: uVision V5.17.0.0
 * Target Device				: STM32F407IGT6
 * --------------------
 * Engineer							: ysloveivy.
 * Revision							: 1.0
 * Created Date					: 2015.11.06
 * --------------------
 * Engineer							:
 * Revision							:
 * Modified Date				:
 * --------------------
 * Additional Comments	:
 *
 * --------------------
 */
//---------------------------------include---------------------------------//
#include "..\include\led.h"
#include "..\include\main.h"
#include "..\include\key.h"
#include "..\include\usart.h"
#include "..\include\adc.h"
#include "..\include\rtc.h"
#include "..\include\stm324xg_eval_sdio_sd.h"
#include "..\include\spi1.h"
#include "..\include\w5500.h"
#include "..\include\socket.h"
#include "..\include\systick.h"
#include "..\include\fpga_ps.h"
#include "..\include\fsmc.h"

#include "usbh_core.h"
#include "usbh_usr.h"
#include "usbh_msc_core.h"

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

//--------------------------------define------------------------------------//
#define VER "1.0"

#define UDP_PORT	30000

//--------------------------------variable---------------------------------//

__ALIGN_BEGIN USBH_HOST                USB_Host __ALIGN_END;
__ALIGN_BEGIN USB_OTG_CORE_HANDLE      USB_OTG_Core __ALIGN_END;

FATFS fatfs0,fatfs1;

//---------------- Function Prototype -------------------//

static int initialize(void);
static int test_process(void);
static int udp_process(void);
static int display_header(void);

//-----------------Function------------------------------//
/*
 * Name					: main
 * Description	: ---
 * Author				: ysloveivy.
 *
 * History
 * --------------------
 * Rev					: 0.00
 * Date					: 11/20/2015
 * 
 * create.
 * --------------------
 */
int main(void)
{
	int i;
	char buffer[20];

	initialize();
	display_header();

	while(1){
		//USB MSC
		USBH_Process(&USB_OTG_Core, &USB_Host);

		//LAN UDP
		udp_process();

		//test
		if(usart4.receive_ok_flag == 1){
			usart4.receive_ok_flag = 0;
			memset(buffer,0,20);
			memcpy(buffer,usart4.receive_buffer,20);
			for(i = 0;i < 20;i++){
				buffer[i] = tolower(buffer[i]);
			}
			if(memcmp(buffer,"test",strlen("test")) == 0){
				test_process();
			}else if(memcmp(buffer,"clear",strlen("clear")) == 0) usart4.printf("\x0c"); //

			else usart4.printf("\r\n\033[1;31;40mBad Command!\r\n");//δʶ

			usart4.printf("\033[1;34;40m>>\033[0;37;40m");//ʾʾ
		}

		if(event){
			if(event & EVENT_KEY_ARM)usart4.printf("\r\n\033[1;35;40m *[ARM KEY is pressed]");
			if(event & EVENT_KEY_FPGA)usart4.printf("\r\n\033[1;35;40m *[FPGA KEY is pressed]");

			usart4.printf("\r\n\033[1;34;40m>>\033[0;37;40m");//ʾʾ
			event = 0;
		}
	}
}
/*
 * Name					: initialize
 * Description	: ---
 * Author				: ysloveivy.
 *
 * History
 * --------------------
 * Rev					: 0.00
 * Date					: 11/20/2015
 * 
 * create.
 * --------------------
 */
static int initialize(void)
{
	led.initialize();
	key.initialize();
	usart4.initialize(115200);
	adc.initialize();
	rtc.initialize();
	systick.initialize();
	fsmc.initialize();
	spi1.initialize();
	w5500.initialize();

	USBH_Init(&USB_OTG_Core, 
			USB_OTG_HS_CORE_ID,
			&USB_Host,
			&USBH_MSC_cb, 
			&USR_cb);

	return 0;
}
/*
 * Name					: udp_process
 * Description	: ---
 * Author				: ysloveivy.
 *
 * History
 * --------------------
 * Rev					: 0.00
 * Date					: 11/20/2015
 * 
 * create.
 * --------------------
 */
static int udp_process(void)
{
	int receive_length;
	unsigned char receive_buffer[100];
	unsigned char pc_ip[4];
	unsigned short int pc_port;
	int counter;

	switch(getSn_SR(0))
	{
		case SOCK_UDP:
			if(getSn_IR(0) & Sn_IR_RECV){	
				setSn_IR(0, Sn_IR_RECV);
			}
			if((counter = getSn_RX_RSR(0))>0){	
				receive_length = recvfrom(0, receive_buffer, counter, pc_ip,&pc_port);
				sendto(0, receive_buffer,receive_length, pc_ip, pc_port);
			}		
			break;
		case SOCK_CLOSED:
			socket(0,Sn_MR_UDP,UDP_PORT,0);
			break;
	}
	return 0;
}
/*
 * Name					: test_process
 * Description	: ---
 * Author				: ysloveivy.
 *
 * History
 * --------------------
 * Rev					: 0.00
 * Date					: 11/20/2015
 * 
 * create.
 * --------------------
 */
static int test_process(void)
{
	int i,j;
	unsigned short int fsmc_read_data;
	static FRESULT res;
	int flag = 0;

	unsigned char write_buffer[1000],read_buffer[1000];
	unsigned short int write_byte, write_counter,read_byte,read_counter;
	FIL file;

	const double power_max[] = {5.5,500,1.28,3.45,2.6};
	const double power_min[] = {4.5,150,1.12,3.15,2.4};
	int errors = 0;
	int second;

	RTC_TimeTypeDef rtc_time;
	RTC_DateTypeDef rtc_date;

	//ADC صԴ===========================================================================
	for(i = 0;i < 5;i++){
		adc.read(i);
	}
	//תɱ׼ֵ
	adc.value[0] *= 6.;  //ѹ
	adc.value[1] /=2.;  //ϵͳ A
	adc.value[1] *= 1000; //ϵͳ mA
	adc.value[3] *= 2.; //3.3V
	adc.value[4] *= 2.; //2.5V

	//ӡԽ
	usart4.printf("\r\n\033[1;35;40m[POWER  ]");
	errors = 0;
	for(i = 0; i < 5; i ++){
		if(adc.value[i] > power_max[i] || adc.value[i] < power_min[i]){
			usart4.printf("\033[1;31;40m");
			errors ++;
		}	else usart4.printf("\033[1;32;40m");

		(i == 1)?usart4.printf(" %.0fmA",adc.value[i]):usart4.printf(" %05.3fV",adc.value[i]);
	}

	if(errors)usart4.printf("\t\033[1;31;40m[Fail]\r\n");
	else usart4.printf("\t\033[1;32;40m[OK]\r\n");


	//RTC ===========================================================================
	errors = 0;
	//ӡԽ
	for(j = 0;j < 2;j++){

		RTC_GetTime(RTC_Format_BIN,&rtc_time);
		RTC_GetDate(RTC_Format_BIN,&rtc_date);
		second = rtc_time.RTC_Seconds;
		usart4.printf("\033[1;35;40m[RTC    ]\033[1;32;40m %02d:%02d:%02d  ",rtc_time.RTC_Hours,rtc_time.RTC_Minutes,rtc_time.RTC_Seconds);
		usart4.printf("20%02d-%02d-%02d\r",rtc_date.RTC_Year,rtc_date.RTC_Month,rtc_date.RTC_Date);

		while(1){
			RTC_GetTime(RTC_Format_BIN,&rtc_time);
			if(second != rtc_time.RTC_Seconds) {
				i = 0;
				break;
			}

			if(i ++ > 2000000){//ʱ˳
				errors ++;
				break;
			}
		}
		if(errors)break;
	}
	usart4.printf("\033[1;35;40m[RTC    ]\033[1;32;40m %02d:%02d:%02d  ",rtc_time.RTC_Hours,rtc_time.RTC_Minutes,rtc_time.RTC_Seconds);
	usart4.printf("20%02d-%02d-%02d",rtc_date.RTC_Year,rtc_date.RTC_Month,rtc_date.RTC_Date);

	if(errors)usart4.printf("\t\t\t\033[1;31;40m[Fail]\r\n");
	else usart4.printf("\t\t\t\033[1;32;40m[OK]\r\n");


	//TF===========================================================================
	errors = 0;
	usart4.printf("\033[1;35;40m[TF Card]\r\n");
	if(SD_Init()){
		usart4.printf(" \033[1;32;40m*Initialize TF Card error!\t\t\t\033[1;31;40m[Fail]\r\n");
		errors ++;
	}else{
		usart4.printf(" \033[1;32;40m*Initialize TF Card sucessful!\r\n");
		usart4.printf(" \033[1;32;40m*INFO:");
		switch(SDCardInfo.CardType)	{
			case SDIO_STD_CAPACITY_SD_CARD_V1_1:usart4.printf(" SDSC V1.1,");break;
			case SDIO_STD_CAPACITY_SD_CARD_V2_0:usart4.printf(" SDSC V2.0,");break;
			case SDIO_HIGH_CAPACITY_SD_CARD:usart4.printf(" SDHC V2.0,");break;
			case SDIO_MULTIMEDIA_CARD:usart4.printf(" MMC Card,");break;
		}	
		usart4.printf("Block = %d,",SDCardInfo.CardBlockSize);					//ʾС		
		usart4.printf("Size = %d MB\r\n",(u32)(SDCardInfo.CardCapacity>>20));	//ʾ

	}

	//sd дļ
	if(errors == 0){
		usart4.printf(" *TF Card Write 10KByte & Read 10KByte");

		//SDļдļ
		res = f_mount(&fatfs0,"0:",1);
		if(res != FR_OK){
			errors ++;
			goto SD_END;
		}

		for(i = 0; i < 1000 ; i ++) {
			write_buffer[i] = i;
		}

		if(f_open(&file, "0:sd.txt",FA_CREATE_ALWAYS | FA_WRITE | FA_READ) == FR_OK){
			for(i = 0;i < 10;i ++ ){
				write_byte = 1000; 
				res= f_write (&file, write_buffer, write_byte, (void *)&write_counter);   

				if((write_counter != 1000) || (res != FR_OK))	{
					errors ++;
					usart4.printf("\t\t\033[1;32;40m[Fail]\r\n");
					goto SD_END;
				}
			}

			f_lseek(&file,0);

			for(i = 0;i < 10;i++){
				read_byte = 1000;
				res = f_read(&file,read_buffer,read_byte,(void *)&read_counter);
				if((write_counter != 1000) || (res != FR_OK))
				{
					errors ++;
					usart4.printf("\t\t\033[1;32;40m[Fail]\r\n");
					goto SD_END;
				}
				for(j = 0;j < 1000;j++){
					if(read_buffer[i] != write_buffer[i]){
						errors ++;
						usart4.printf("\t\t\033[1;32;40m[Fail]\r\n");
						goto SD_END;
					}
				}
			}
			f_close(&file);
			//	f_mount( NULL,"0:" ,1);
			usart4.printf("\t\t\033[1;32;40m[OK]\r\n");
		}

	}
SD_END: ;
	usart4.printf("\033[1;32;40m"); //ʾɫ 
	if(errors)usart4.printf(" *TF Card Test ......\t\t\t\t\033[1;31;40m[Fail]\r\n");
	else usart4.printf(" *TF Card Test ......\t\t\t\t\033[1;32;40m[OK]\r\n");


	//USB HOST U̲===========================================================================

	errors = 0;
	usart4.printf("\033[1;35;40m[U DISK ]\r\n");

	if(HCD_IsDeviceConnected(&USB_OTG_Core)){

		usart4.printf(" \033[1;32;40m*Initialize USB Disk sucessful!\r\n");

		usart4.printf(" *USB DISK Write 10KByte & Read 10KByte");

		res = f_mount(&fatfs1,"1:",1);
		if(res != FR_OK){
			errors ++;
			usart4.printf("\t\t\033[1;31;40m[Fail]\r\n");
			goto U_DISK_END;
		}

		for(i = 0; i < 1000 ; i ++) {
			write_buffer[i] = i;
		}

		if(f_open(&file, "1:u_disk.txt",FA_CREATE_ALWAYS | FA_WRITE | FA_READ) == FR_OK) {
			for(i = 0;i < 10;i ++ ){
				write_byte = 1000; 
				res= f_write (&file, write_buffer, write_byte, (void *)&write_counter);   

				if((write_counter != 1000) || (res != FR_OK))	{
					errors ++;
					usart4.printf("\t\t\033[1;31;40m[Fail]\r\n");
					goto U_DISK_END;
				}
			}

			f_lseek(&file,0);

			for(i = 0;i < 10;i++){
				read_byte = 1000;
				res = f_read(&file,read_buffer,read_byte,(void *)&read_counter);
				if((write_counter != 1000) || (res != FR_OK)){
					errors ++;
					usart4.printf("\t\t\033[1;31;40m[Fail]\r\n");
					goto U_DISK_END;
				}
				for(j = 0;j < 1000;j++){
					if(read_buffer[i] != write_buffer[i]){
						errors ++;
						usart4.printf("\t\t\033[1;31;40m[Fail]\r\n");
						goto U_DISK_END;
					}
				}
			}
			f_close(&file);
			//		f_mount( NULL,"1:" ,1);
			usart4.printf("\t\t\033[1;32;40m[OK]\r\n");
		}

	}else {
		usart4.printf(" \033[1;32;40m*Initialize USB Disk error!\t\t\t\033[1;31;40m[Fail]\r\n");
		errors ++;
	}
U_DISK_END:;
	   usart4.printf("\033[1;32;40m"); //ʾɫ 
	   if(errors)usart4.printf(" *USB DISK Test ......\t\t\t\t\033[1;31;40m[Fail]\r\n");
	   else usart4.printf(" *USB DISK Test ......\t\t\t\t\033[1;32;40m[OK]\r\n");


	   //IAP SD FPGA ֮ fpgasdram,Գɹfpga,˸
	   errors = 0;
	   usart4.printf("\033[1;35;40m[FPGA PS]\r\n");


	   fpga_ps.initialize();
	   usart4.printf("\033[1;32;40m"); //ʾɫ 

	   usart4.printf(" *Try config fpga form TF Card!\r\n");

	   if(fpga_ps.from_tf() == 0){
		   usart4.printf(" *Config FPGA from TF Card successful!\t\t[OK]\r\n");
	   }else {
		   usart4.printf(" *Try config fpga form USB Disk!\r\n");	
		   if(fpga_ps.from_udisk() == 0) {


			   usart4.printf(" *Config FPGA from USB Disk successful!\t\t[OK]\r\n");

		   } else usart4.printf(" *Download FPGA firmware error!\t\t\t\033[1;31;40m[Fail]\r\n");

	   }


	   //FSMC дfpgaڲram ========================================================================
	   //fpga ڽ 512ֽram, ˳7 512ֽڶд,У
	   errors = 0;
	   usart4.printf("\033[1;35;40m[BUS W/R]\r\n");
	   usart4.printf("\033[1;32;40m *Test RAM Block ");
	   for(j = 0;j < 7;j++){
		   flag = 0;

		   for(i = 0;i < 512;i++){
			   fpga_write(i,i << j);
		   }

		   for(i = 0;i < 1000;i++);

		   for(i = 0;i < 512;i++){
			   fsmc_read_data = fpga_read(i);
			   if(fsmc_read_data != (i << j)){
				   flag  = 1;
				   errors ++;
			   }
		   }
		   if(flag)usart4.printf("\033[1;31;40m%d  ",j);
		   else usart4.printf("\033[1;32;40m%d  ",j);
	   }
	   if(errors) usart4.printf("\t\t\033[1;31;40m[Fail]\r\n");
	   else 	usart4.printf("\t\t\033[1;32;40m[OK]\r\n");


	   return 0;
}
/*
 * Name					: display_header
 * Description	: ---
 * Author				: XiaomaGee.
 *
 * History
 * --------------------
 * Rev					: 0.00
 * Date					: 11/20/2015
 * 
 * create.
 * --------------------
 */
	static int
display_header(void)
{

	usart4.printf("\x0c"); //
	usart4.printf("\033[1;35;40m");//

	usart4.printf("................................\r\n");
	usart4.printf(".                              .\r\n");
	usart4.printf(".   iCore3 Function Test V%s  .\r\n",VER);
	usart4.printf(".                              .\r\n");
	usart4.printf("................................\r\n");
	usart4.printf(".                              .\r\n");
	usart4.printf(".   Gingko Technology Co.,Ltd. .\r\n");
	usart4.printf(".                              .\r\n");
	usart4.printf("................................\r\n");
	usart4.printf(".   test ûسв  .\r\n");
	usart4.printf("................................\r\n");

	usart4.printf("\033[1;34;40m>>\033[0;37;40m");//ʾʾ

	return 0;
}

