/* 
 * --------------------
 * Company					: LUOYANG GINGKO TECHNOLOGY CO.,LTD.
 * BBS						: http://www.eeschool.org
 * --------------------
 * Project Name			: SDRAM_Ctrl_Top
 * Module Name				: Data_Ctrl
 * Description				: The codes of "Data_Ctrl"
 * --------------------
 * Tool Versions			: Quartus II 13.1
 * Target Device			: Cyclone IV E  EP4CE10F17C8
 * --------------------
 * Engineer					: woshi56hao
 * Revision					: V0.0
 * Created Date			: 2014-04-26
 * --------------------
 * Engineer					:
 * Revision					:
 * Modified Date			:
 * --------------------
 * Additional Comments	: SDRAM_Model	W9812G2IH
 * 
 * --------------------
 */

//--------------------Timescale------------------------------//
`timescale 1 ns / 1 ps

//--------------------Module_Data_Ctrl-----------------------//
module Data_Ctrl(
	SDRAM_CLK,		//输入SDRAM_Ctrl_Top模块主时钟,50M
	RST_n,			//输入全局复位信号
	Work_State,		//输入工作状态
	Work_Cnt_CLK,	//输入工作状态时钟计数器
	SDRAM_Data_in,	//输入写入SDRAM的数据
	SD_DB,			//输入输出SDRAM的双向DB总线
	SDRAM_Data_out	//输出读SDRAM得到的数据
	);

	input SDRAM_CLK,RST_n;
	input [8:0] Work_State,Work_Cnt_CLK;
	input [15:0] SDRAM_Data_in;
	inout [15:0] SD_DB;
	output[15:0] SDRAM_Data_out;

//--------------------Include--------------------------------//
	`include		"Para_Ctrl.v"	//在本模块加入全局变量定义文件
//--------------------SD_DB----------------------------------//
	assign SD_DB = ((Work_State == `Work_WR) ? SDRAM_Data_in : 16'HZZZZ);//在写状态,将数据SDRAM_Data_in通过SD_DB写入SDRAM	

//	assign SDRAM_Data_out = SD_DB;//Data_out_r;//输出读SDRAM得到的数据
	
	reg [15:0] Data_out_r = 16'd0;
	always @(posedge SDRAM_CLK or negedge RST_n)
		if (!RST_n)
			Data_out_r <= 16'd0;
		else if ((Work_State == `Work_RD) && (Work_Cnt_CLK == 9'd4))//11		
			Data_out_r <= SD_DB;//在读状态,将SDRAM内部数据通过SD_DB读到Data_out_r中

	assign SDRAM_Data_out = Data_out_r;//输出读SDRAM得到的数据

//--------------------Endmodule------------------------------//
endmodule
	