/* 
 * --------------------
 * Company					: LUOYANG GINGKO TECHNOLOGY CO.,LTD.
 * BBS						: http://www.eeschool.org
 * --------------------
 * Project Name			: SDRAM_Test_Top
 * Module Name				: SDRAM_Test_Top
 * Description				: The codes of "fsmc"
 * --------------------
 * Tool Versions			: Quartus II 13.1
 * Target Device			: Cyclone IV E  EP4CE10F17C8
 * --------------------
 * Engineer					: xiaorenwu
 * Revision					: V0.0
 * Created Date			: 2014-04-26
 * --------------------
 * Engineer					:
 * Revision					:
 * Modified Date			:
 * --------------------
 * Additional Comments	: SDRAM_Model	W9812G2IH
 * 
 * --------------------
 */
 
 module fsmc(
	ab,
	db,
	wrn,
	rdn,
	csn,
	PLL_100M,
	RST_n,
	nadv
 	);
	
	input [8:0]ab;
	inout [15:0]db;
	input wrn;
	input rdn;
	input csn;
	input PLL_100M;
	input RST_n; 
	input nadv;
	
	wire rd;
	wire wr;
	
	assign rd = (csn | rdn);
	assign wr = (csn | wrn);
	
	wire [15:0]DB_OUT;
	
	assign db = !rd ? DB_OUT : 16'hzzzz;

	reg wr_clk1,wr_clk2;
	
	always @(posedge PLL_100M or negedge RST_n)
		begin
			if(!RST_n)
				begin
					wr_clk1 <= 1'd1;
					wr_clk2 <= 1'd1;
				end
			else
				{wr_clk2,wr_clk1} <= {wr_clk1,wr};	//提取写时钟
		end
		
	reg rd_clk;
	
	always @(posedge PLL_100M or negedge RST_n)
		begin
			if(!RST_n)
				rd_clk <= 1'd1;
			else 
				rd_clk <= rd;								//提取读时钟
		end
		
	wire clk = (!wr_clk2 | !rd);
				
		
		
my_ram      u1(											//ram块例化
					.address(ab),
					.clock(clk),
					.data(db),
					.wren(!wr),
					.rden(!rd),
					.q(DB_OUT),
					);
	
	
endmodule

	
 
 